from datetime import datetime
from decimal import *


class BaseEntity:
    def __init__(self):
        self._timestamp = None
        self._event = None

    def initFromJournal(self, data):
        timestamp = self.getParam(data, "timestamp")
        self._timestamp = datetime.strptime(timestamp, '%Y-%m-%dT%H:%M:%SZ')
        self._event = self.getParam(data, "event")

    def getTimestamp(self):
        return self._timestamp

    def getEvent(self):
        return self._event

    def getParam(self, data, key, default=None):
        if key in data:
            return data[key]
        else:
            return default

    def getDecimal(self, value):
        if value is not None:
            return Decimal(value)
        else:
            return None
