import locale
from decimal import *
from package.Journal.Events.BaseEntity import BaseEntity


class AtmosphereElement(BaseEntity):
    def __init__(self):
        super().__init__()
        self._name = ''
        self._percent = Decimal(0)

    def initFromJournal(self, data):
        self._name = self.getParam(data, "Name")
        self._percent = Decimal(self.getParam(data, "Percent"))

    def initFromDatabase(self, data) -> None:
        self._name = data['element']
        self._percent = Decimal(data["percent"])

    # simple getters
    def getName(self):
        return self._name

    def getPercent(self):
        return self._percent

    def getPercentAsString(self, decimals: int = 4) -> str:
        numFormat = '%.' + str(decimals) + 'f'
        return locale.format_string(numFormat, self._percent, True) + " %"
