from package.Journal.Events.BaseEntity import BaseEntity


class ApproachBody(BaseEntity):
    def __init__(self):
        super().__init__()
        self._starSystem = None
        self._systemAddress = None
        self._body = None
        self._bodyId = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._systemAddress = self.getParam(data, "SystemAddress")
        self._starSystem = self.getParam(data, "StarSystem")
        self._body = self.getParam(data, "Body")
        self._bodyId = self.getParam(data, "BodyID")

    def getSystemAddress(self):
        return self._systemAddress

    def getStarSystem(self):
        return self._starSystem

    def getBody(self):
        return self._body

    def getBodyId(self):
        return self._bodyId
