from package.Installer.Tables.TableAbstract import TableAbstract


class WorthScanningRuleTable(TableAbstract):
    def installMysql(self):
        query = """create table worth_scanning_rule (
            id int unsigned auto_increment,
            name varchar(255) not null,
            primary key(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

        self.insertData()

    def installSqlite(self):
        query = """create table IF NOT EXISTS worth_scanning_rule (
            id integer,
            name text,
            primary key(id)
        );"""
        self.db.query(query)

        self.insertData()

    def insertData(self):
        # worth scanning default WW
        query = 'insert into worth_scanning_rule(id, name) values (1, "worth_scanning_water_world");'
        self.db.query(query)

        # worth scanning default ELW
        query = 'insert into worth_scanning_rule(id, name) values (2, "worth_scanning_earth_like");'
        self.db.query(query)

        # worth scanning default AW
        query = 'insert into worth_scanning_rule(id, name) values (3, "worth_scanning_ammonia");'
        self.db.query(query)

        # worth scanning default Terraforming
        query = 'insert into worth_scanning_rule(id, name) values (4, "worth_scanning_terraforming");'
        self.db.query(query)
