from package.Installer.Tables.TableAbstract import TableAbstract


class WorthScanningCheckTable(TableAbstract):
    def installMysql(self):
        query = """create table worth_scanning_check (
            rule_id int unsigned not null,
            field varchar(255) not null,
            value varchar(255) not null,
            operator varchar(10) not null,
            key (rule_id, field, operator),
            foreign key (rule_id) references worth_scanning_rule(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

        self.insertData()

    def installSqlite(self):
        query = """create table IF NOT EXISTS worth_scanning_check (
            rule_id integer,
            field text,
            value text,
            operator text,
            primary key (rule_id, field, operator)
        );"""
        self.db.query(query)

        self.insertData()

    def insertData(self):
        # worth scanning rule WW
        query = 'insert into worth_scanning_check(rule_id, field, value, operator) values (1, "type", "Water world", "EQUALS");'
        self.db.query(query)

        # worth scanning rule ELW
        query = 'insert into worth_scanning_check(rule_id, field, value, operator) values (2, "type", "Earthlike body", "EQUALS");'
        self.db.query(query)

        # worth scanning rule AW
        query = 'insert into worth_scanning_check(rule_id, field, value, operator) values (3, "type", "Ammonia world", "EQUALS");'
        self.db.query(query)

        # worth scanning rule Terraforming
        query = 'insert into worth_scanning_check(rule_id, field, value, operator) values (4, "terraformable", "1", "EQUALS");'
        self.db.query(query)
