from package.Installer.Tables.TableAbstract import TableAbstract


class SystemsTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS systems (
            id int unsigned AUTO_INCREMENT,
            system_address bigint unsigned not null,
            name varchar(255) not null,
            pos_x decimal(32,6) not null,
            pos_y decimal(32,6) not null,
            pos_z decimal(32,6) not null,
            body_count int default null,
            scan_complete tinyint not null default 0,
            primary key(id),
            unique key (system_address),
            FULLTEXT idx_name (name)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS systems (
            id integer,
            system_address integer,
            name text,
            pos_x real,
            pos_y real,
            pos_z real,
            body_count integer,
            scan_complete integer default 0,
            primary key(id)
        )"""
        self.db.query(query)
