from package.Installer.Tables.TableAbstract import TableAbstract


class StarsTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS stars(
            id bigint unsigned auto_increment,
            system_address bigint unsigned not null,
            name varchar(255) not null,
            body_id smallint unsigned not null,
            is_main_star tinyint default 0,
            type varchar(200) not null,
            subclass int default null,
            distance decimal(32,6) unsigned not null,
            mass decimal(32,6) not null,
            radius decimal(32,6) not null,
            absolute_magnitude decimal(32,6) not null,
            age int unsigned not null,
            temperature decimal(32,6) not null,
            luminosity varchar(200) not null,
            semi_major_axis decimal(32,6) not null,
            eccentricity decimal(32,6) not null,
            inclination decimal(32,6) not null,
            periapsis decimal(32,6) not null,
            orbital_period decimal(32,6) not null,
            rotation_period decimal(32,6) not null,
            axial_tilt decimal(32,6) not null,
            was_discovered tinyint not null,
            discovery_date datetime default null,
            parents varchar(255) default "[]",
            primary key(id),
            foreign key (system_address) references systems(system_address)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS stars(
            id integer,
            system_address integer,
            name text,
            body_id integer,
            is_main_star integer default 0,
            type text,
            subclass integer,
            distance real,
            mass real,
            radius real,
            absolute_magnitude real,
            age integer,
            temperature real,
            luminosity text,
            semi_major_axis real,
            eccentricity real,
            inclination real,
            periapsis real,
            orbital_period real,
            rotation_period real,
            axial_tilt real,
            was_discovered integer,
            discovery_date timestamp,
            parents text,
            primary key(id)
        )"""
        self.db.query(query)
