from package.Installer.Tables.TableAbstract import TableAbstract


class SsaSignalsTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS ssa_signals(
            id bigint unsigned auto_increment,
            type varchar(255) default "",
            type_localised varchar(255) default "",
            amount int,
            primary key(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS ssa_signals(
            id integer,
            type text default "",
            type_localised text default "",
            amount integer,
            primary key(id)
        );"""
        self.db.query(query)

    def updateTo1Mysql(self):
        query = "ALTER TABLE ssa_signals DROP FOREIGN KEY ssa_signals_ibfk_1;"
        self.db.query(query)

        query = "ALTER TABLE ssa_signals DROP COLUMN ring_id;"
        self.db.query(query)

        query = "ALTER TABLE ssa_signals DROP COLUMN multiple_hotspot;"
        self.db.query(query)

    def updateTo1Sqlite(self):
        # rename old table
        query = "ALTER TABLE ssa_signals RENAME TO tmp_ssa_signals;"
        self.db.query(query)

        # create new table
        self.installSqlite()

        # copy data
        query = "insert into ssa_signals select id, type, type_localised, amount from tmp_ssa_signals;"
        self.db.query(query)

        # delete tmp table
        query = "drop table tmp_ssa_signals;"
        self.db.query(query)
