from package.Installer.Tables.TableAbstract import TableAbstract


class SsaSignalsRingTable(TableAbstract):
    def installMysql(self):
        query = """create table ssa_signals_ring (
            ring_id bigint unsigned,
            ssa_id bigint unsigned,
            multiple_hotspot tinyint default 0,
            key (ring_id, ssa_id),
            foreign key (ring_id) references rings(id)
        )  ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table ssa_signals_ring (
            ring_id integer,
            ssa_id integer,
            multiple_hotspot integer default 0,
            primary key (ring_id, ssa_id)
        );"""
        self.db.query(query)

    def updateTo1Mysql(self):
        self.installMysql()
        self.migrateVersion1()

    def updateTo1Sqlite(self):
        self.installSqlite()
        self.migrateVersion1()

    def migrateVersion1(self):
        query = """insert into ssa_signals_ring select ring_id, id, 0 from ssa_signals;"""
        self.db.query(query)
