from package.Installer.Tables.TableAbstract import TableAbstract


class SsaSignalsPlanetTable(TableAbstract):
    def installMysql(self):
        query = """create table ssa_signals_planet (
            planet_id bigint unsigned,
            ssa_id bigint unsigned,
            key (planet_id, ssa_id),
            foreign key (planet_id) references bodies(id)
        )  ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table ssa_signals_planet (
            planet_id integer,
            ssa_id integer,
            primary key (planet_id, ssa_id)
        );"""
        self.db.query(query)

    def updateTo1Mysql(self):
        self.installMysql()

    def updateTo1Sqlite(self):
        self.installSqlite()
