from package.Installer.Tables.TableAbstract import TableAbstract


class RingsTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS rings(
            id bigint unsigned auto_increment,
            system_address bigint unsigned not null,
            name varchar(255) not null,
            ring_class varchar(255) not null,
            mass decimal(32,6) not null,
            inner_rad decimal(32,6) not null,
            outer_rad decimal(32,6) not null,
            primary key(id),
            foreign key (system_address) references systems(system_address)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS rings(
            id integer,
            system_address integer,
            name text,
            ring_class text,
            mass real,
            inner_rad real,
            outer_rad real,
            primary key (id)
        );"""
        self.db.query(query)
