from package.Installer.Tables.TableAbstract import TableAbstract


class PilotMaterialsTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS pilot_materials (
            name varchar(100) not null,
            category enum('raw', 'manufactured', 'encoded') not null,
            amount int,
            key (name, category)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS pilot_materials (
            name text,
            category text,
            amount integer,
            primary key(name, category)
        );"""
        self.db.query(query)
