from package.Installer.Tables.TableAbstract import TableAbstract


class OrganicSamplesTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS organic_samples
        (
            id bigint unsigned auto_increment,
            system_address bigint unsigned not null,
            body_id bigint unsigned unsigned,
            scan_type enum("Log", "Sample", "Analyse"),
            genus varchar(255) default '',
            genus_localised varchar(255) default '',
            species varchar(255) default '',
            species_localised varchar(255) default '',
            variant VARCHAR(255) DEFAULT '',
            variant_localised VARCHAR(255) DEFAULT '',
            date text,
            primary key(id),
            foreign key (system_address) references systems(system_address)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS organic_samples
        (
            id integer,
            system_address integer,
            body_id integer,
            scan_type text,
            genus text,
            genus_localised text,
            species text,
            species_localised text,
            date timestamp,
            variant text,
            variant_localised text,
            primary key(id)
        );"""
        self.db.query(query)

    def updateTo5Mysql(self):
        query = "ALTER TABLE `organic_samples` ADD variant VARCHAR(255) DEFAULT '' AFTER species_localised"
        self.db.query(query)

        query = "ALTER TABLE `organic_samples` ADD variant_localised VARCHAR(255) DEFAULT '' AFTER variant"
        self.db.query(query)

    def updateTo5Sqlite(self):
        query = "ALTER TABLE `organic_samples` ADD variant text"
        self.db.query(query)

        query = "ALTER TABLE `organic_samples` ADD variant_localised text"
        self.db.query(query)
