from package.Installer.Tables.TableAbstract import TableAbstract


class MaterialBodiesTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS material_bodies(
            material_id smallint unsigned not null,
            body_id bigint unsigned not null,
            percent decimal(32,6) not null,
            key (material_id, body_id),
            foreign key (material_id) references materials(id),
            foreign key (body_id) references bodies(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS material_bodies(
            material_id integer,
            body_id integer,
            percent real,
            primary key (material_id, body_id)
        )"""
        self.db.query(query)
