from package.Installer.Tables.TableAbstract import TableAbstract


class FlightlogTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS flightlog (
            id bigint unsigned auto_increment,
            system_address bigint unsigned not null,
            jump_distance decimal(32,6) not null,
            fuel_used decimal(32,6) not null,
            fuel_level decimal(32,6) not null,
            date datetime not null,
            primary key(id),
            foreign key (system_address) references systems(system_address)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS flightlog (
            id integer,
            system_address integer,
            jump_distance real,
            fuel_used real,
            fuel_level real,
            date timestamp,
            primary key(id)
        );"""
        self.db.query(query)
