from package.Installer.Tables.TableAbstract import TableAbstract
from package.Database.Version import DB_VERSION


class ConfigTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS config (
            id int unsigned AUTO_INCREMENT,
            config_name varchar(100) not null,
            config_value varchar(255),
            primary key(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

        self.insertData()

    def installSqlite(self):
        query = """create table IF NOT EXISTS config (
            id integer,
            config_name text,
            config_value text,
            primary key(id)
        )"""
        self.db.query(query)

        self.insertData()

    def insertData(self):
        query = 'insert into config(config_name, config_value) values ("journal_directory", "");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("screenshot_conversion", "0");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("screenshot_source_dir", "");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("screenshot_destination_dir", "");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("ui_language", "en");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("home_system_name", "Sol");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("home_system_pos_x", "0");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("home_system_pos_y", "0");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("home_system_pos_z", "0");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("desktop_notifications", "0");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("screenshot_format", "png");'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("automatic_credit_reset", 0);'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("temperature_format", "C");'
        self.db.query(query)
        self.addDbVersion()

    def addDbVersion(self):
        query = 'insert into config(config_name, config_value) values ("db_version", "' + str(DB_VERSION) + '");'
        self.db.query(query)

    def updateTo1(self):
        query = 'insert into config(config_name, config_value) values ("db_version", "1");'
        self.db.query(query)

    def updateTo2(self):
        query = 'insert into config(config_name, config_value) values ("desktop_notifications", "0");'
        self.db.query(query)

    def updateTo3(self):
        query = 'insert into config(config_name, config_value) values ("screenshot_format", "png");'
        self.db.query(query)

    def updateTo6(self):
        query = 'insert into config(config_name, config_value) values ("automatic_credit_reset", 0);'
        self.db.query(query)
        query = 'insert into config(config_name, config_value) values ("temperature_format", "C");'
        self.db.query(query)
