from package.Installer.Tables.TableAbstract import TableAbstract


class CodexTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS codex (
            id bigint unsigned auto_increment,
            body_id bigint unsigned default NULL,
            name varchar(255) default "",
            name_localised varchar(255) default "",
            category varchar(255) default "",
            subcategory varchar(255) default "",
            region varchar(255) default "",
            region_localised varchar(255) default "",
            nearest_destination varchar(255) default "",
            nearest_destination_localised varchar(255) default "",
            latitude decimal(32,6) default null,
            longitude decimal(32,6) default null,
            system_address bigint unsigned not null,
            is_new_entry tinyint default 0,
            voucher_amount int,
            scan_date datetime default null,
            primary key(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS codex (
            id integer,
            body_id integer,
            name text default "",
            name_localised text default "",
            category text default "",
            subcategory text default "",
            region text default "",
            region_localised text default "",
            nearest_destination text default "",
            nearest_destination_localised text default "",
            latitude real default null,
            longitude real default null,
            system_address integer,
            is_new_entry integer default 0,
            voucher_amount integer,
            scan_date timestamp,
            primary key(id)
        );"""
        self.db.query(query)
