from package.Installer.Tables.TableAbstract import TableAbstract


class CheckerConfigurationTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS checker_configuration(
                    checker_name varchar(255) NOT NULL,
                    config_name varchar(100) NOT NULL,
                    config_value varchar(255),
                    key (checker_name, config_name)
                ) ENGINE=InnoDB;"""
        self.db.query(query)

        self.insertData()

    def installSqlite(self):
        query = """create table IF NOT EXISTS checker_configuration (
                    checker_name text,
                    config_name text,
                    config_value text,
                    primary key (checker_name, config_name)
                );"""
        self.db.query(query)

        self.insertData()

    def insertData(self):
        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckHeliumRichSystem", "helium_threshold", "29.5");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckHighEccentricity", "eccentricity_threshold", "0.9");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckHighGravity", "gravity_threshold", "4");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManySmallMoons", "moon_count", "4");'
        self.db.query(query)
        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManySmallMoons", "moon_radius", "300");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckFastOrbit", "orbital_period", "14400");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckNarrowRings", "ring_width", "1000");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckSmallBody", "min_radius", "300");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckWaterGiants", "radius", "30500");'
        self.db.query(query)
        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckWaterGiants", "mass", "100");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckWideRings", "ring_width", "1000000");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckWaterWorldManyMoons", "moon_count", "4");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManyWaterworlds", "waterworld_count", "4");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManyWaterGiants", "watergiant_count", "3");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManyEarthlikes", "earthlike_count", "2");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManyBlackHoles", "blackhole_count", "2");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckManyAmmoniaWorlds", "ammoniaworld_count", "2");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckMoonCloseToRing", "times_radius", "10");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckMaterials", "arsenic", "2.7");'
        self.db.query(query)
        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckMaterials", "polonium", "1.1");'
        self.db.query(query)
        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckMaterials", "germanium", "6");'
        self.db.query(query)
        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckMaterials", "selenium", "0");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckCloseOrbit", "times_body_radius", "4");'
        self.db.query(query)

        query = 'insert into checker_configuration(checker_name, config_name, config_value) values ("CheckCloseBinary", "radius_axis_factor", "0.3");'
        self.db.query(query)

    def updateTo6Mysql(self):
        self.installMysql()

    def updateTo6Sqlite(self):
        self.installSqlite()
