from package.Installer.Tables.TableAbstract import TableAbstract


class BodyRingsTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS body_rings(
            ring_id bigint unsigned not null,
            body_id bigint unsigned,
            star_id bigint unsigned,
            key (ring_id, body_id, star_id),
            foreign key (ring_id) references rings(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS body_rings(
            ring_id integer,
            body_id integer,
            star_id integer,
            primary key (ring_id, body_id, star_id)
        );"""
        self.db.query(query)
