from package.Installer.Tables.TableAbstract import TableAbstract


class BodiesTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS bodies(
            id bigint unsigned auto_increment,
            system_address bigint unsigned not null,
            name varchar(255) not null,
            body_id smallint unsigned not null,
            type varchar(100) not null,
            distance decimal(32,6) unsigned not null,
            mass decimal(32,6) not null,
            radius decimal(32,6) not null,
            tidal_lock tinyint not null,
            terraformable tinyint not null,
            gravity decimal(32,6) not null,
            temperature decimal(32,6) default null,
            surface_pressure decimal(32,6) default null,
            atmosphere varchar(255) default null,
            atmosphere_type varchar(255) default null,
            volcanism varchar(255) default null,
            landable tinyint not null,
            semi_major_axis decimal(32,6) not null,
            eccentricity decimal(32,6) not null,
            inclination decimal(32,6) not null,
            periapsis decimal(32,6) not null,
            orbital_period decimal(32,6) not null,
            rotation_period decimal(32,6) not null,
            axial_tilt decimal(32,6) not null,
            was_discovered tinyint not null,
            was_mapped tinyint not null,
            detail_scan tinyint not null default 0,
            efficient_scan tinyint not null default 0,
            discovery_date datetime not null,
            parents varchar(255) default "[]",
            primary key(id),
            foreign key (system_address) references systems(system_address)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS bodies(
            id integer,
            system_address integer,
            name text,
            body_id integer,
            type text,
            distance real,
            mass real,
            radius real,
            tidal_lock integer,
            terraformable integer,
            gravity real,
            temperature real,
            surface_pressure real,
            atmosphere text,
            atmosphere_type text,
            volcanism text,
            landable integer,
            semi_major_axis real,
            eccentricity real,
            inclination real,
            periapsis real,
            orbital_period real,
            rotation_period real,
            axial_tilt real,
            was_discovered integer,
            was_mapped integer,
            detail_scan integer default 0,
            efficient_scan integer default 0,
            discovery_date timestamp,
            parents text, 
            primary key(id)
        )"""
        self.db.query(query)
