from package.Installer.Tables.TableAbstract import TableAbstract


class BodiesAtmosphereTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS bodies_atmosphere (
            body_id bigint unsigned not null,
            element varchar(100) not null,
            percent decimal(32,6) not null,
            key (body_id, element),
            foreign key (body_id) references bodies(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS bodies_atmosphere (
            body_id integer,
            element text,
            percent real,
            primary key (body_id, element)
        );"""
        self.db.query(query)
