from package.Installer.Tables.TableAbstract import TableAbstract


class BioCalculationTable(TableAbstract):
    def installMysql(self):
        query = """create table IF NOT EXISTS bio_calculation (
            id bigint unsigned auto_increment,
            name varchar(255) not null,
            value int not null,
            primary key(id)
        ) ENGINE=InnoDB;"""
        self.db.query(query)

    def installSqlite(self):
        query = """create table IF NOT EXISTS bio_calculation (
            id integer,
            name text default "",
            value integer,
            primary key(id)
        );"""
        self.db.query(query)

    def updateTo4Mysql(self):
        self.installMysql()

    def updateTo4Sqlite(self):
        self.installSqlite()
