import logging
from package.Config.ConfigManager import ConfigManager
from package.Helper.ClassLoader import ClassLoader
from package.Database.Version import DB_VERSION


logger = logging.getLogger(__name__)

class DbUpdater:
    def update(self):
        packageBase = "package.Installer.Tables."

        updateTables = [
            "ConfigTable",
            "SsaSignalsRingTable",
            "SsaSignalsPlanetTable",
            "SsaSignalsTable",
            "BioCalculationTable",
            "OrganicSamplesTable",
            "CheckerConfigurationTable",
        ]

        logger.info("Starting update")

        # get current db version
        currentVersion = ConfigManager.getConfigValue("db_version")
        if currentVersion is None:
            logger.info("No current DB version in db, using 0")
            currentVersion = 0
        else:
            logger.info("Current DB version: %s", currentVersion)
            currentVersion = int(currentVersion)

        try:
            while currentVersion < DB_VERSION:
                currentVersion = currentVersion + 1

                logger.info("Updating tables for version %s", currentVersion)

                for table in updateTables:
                    logger.info("Updating table %s", table)
                    packageName = packageBase + table
                    tableClass = ClassLoader.getClass(packageName, table)
                    tableClass.updateTo(currentVersion)

            # update DB Version
            self.updateDbVersion()
        except:
            logger.exception("Critical error during update")

        logger.info("Update finished")

    def updateDbVersion(self):
        logger.info("Updating DB Version")
        ConfigManager.setConfigValue("db_version", DB_VERSION)
