from PyQt5 import QtCore
from package.Config.ConfigReader import ConfigReader
from package.Database.DbFactory import DbFactory
from package.Installer.DbTables import RESET_TABLES


class DbReseter(QtCore.QObject):
    updateBarAllSignal = QtCore.pyqtSignal(int)
    finishedSignal = QtCore.pyqtSignal()

    def reset(self):
        configData = ConfigReader.getConfigData()
        if configData["Database"]["DatabaseType"] == DbFactory.DB_MYSQL:
            self.resetMysql()
        elif configData["Database"]["DatabaseType"] == DbFactory.DB_SQLITE:
            self.resetSqlite()
        else:
            raise EnvironmentError("Database type not found")

        self.updateBarAllSignal.emit(100)
        self.finishedSignal.emit()

    def resetMysql(self):
        db = DbFactory.getDatabase()

        count = 1
        onePercent = 100 / len(RESET_TABLES)

        db.query("SET FOREIGN_KEY_CHECKS = 0")

        for tableName in RESET_TABLES:
            db.query("TRUNCATE TABLE " + tableName)

            progress = count * onePercent
            self.updateBarAllSignal.emit(progress)
            count += 1

        db.query("SET FOREIGN_KEY_CHECKS = 1")

    def resetSqlite(self):
        db = DbFactory.getDatabase()

        count = 1
        onePercent = 100 / len(RESET_TABLES)

        for tableName in RESET_TABLES:
            db.delete(tableName, {})

            progress = count * onePercent
            self.updateBarAllSignal.emit(progress)
            count += 1
