import logging
from package.Helper.ClassLoader import ClassLoader


logger = logging.getLogger(__name__)

class DbInstaller:
    def install(self):
        logger.info("Starting installation")
        packageBase = "package.Installer.Tables."

        tables = [
            "SystemsTable",
            "BodiesTable",
            "StarsTable",
            "MaterialsTable",
            "MaterialBodiesTable",
            "ConfigTable",
            "ConfigCheckerTable",
            "RingsTable",
            "BodyRingsTable",
            "SsaSignalsTable",
            "SsaSignalsRingTable",
            "SsaSignalsPlanetTable",
            "CodexTable",
            "CalculationTable",
            "FlightlogTable",
            "BodiesAtmosphereTable",
            "PilotMaterialsTable",
            "OrganicSamplesTable",
            "WorthScanningRuleTable",
            "WorthScanningCheckTable",
            "BioCalculationTable",
            "CheckerConfigurationTable",
        ]

        try:
            for table in tables:
                logger.info("Installing table %s", table)
                packageName = packageBase + table
                tableClass = ClassLoader.getClass(packageName, table)
                tableClass.install()
        except:
            logger.exception("Critical error during installation")

        logger.info("Installation finished")
