from package.Config.ConfigReader import ConfigReader
from package.Database.DbFactory import DbFactory
from package.Database.DbMysql import DbMysql


class DbChecker:
    def checkConnection(self, host, dbName, user, password, port):
        try:
            db = DbMysql(host, user, password, dbName, port)
            return True
        except:
            return False

    def checkIfTablesExist(self):
        db = DbFactory.getDatabase()
        configData = ConfigReader.getConfigData()

        schema = configData["Mysql"]["DbName"]

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "config"})
        if result[0]["count"] != 1:
            return False

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "configChecker"})
        if result[0]["count"] != 1:
            return False

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "systems"})
        if result[0]["count"] != 1:
            return False

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "bodies"})
        if result[0]["count"] != 1:
            return False

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "stars"})
        if result[0]["count"] != 1:
            return False

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "materials"})
        if result[0]["count"] != 1:
            return False

        result = db.select("information_schema.tables", ["count(*) as count"], {"TABLE_SCHEMA": schema, "TABLE_NAME": "material_bodies"})
        if result[0]["count"] != 1:
            return False

        return True
