from .ImporterAbstract import ImporterAbstract

class ImporterSystem(ImporterAbstract):
    def insert(self):
        data = {
            "system_address": self.data.getSystemAddress(),
            "name": self.data.getStarSystem(),
            "pos_x": self.data.getPosX(),
            "pos_z": self.data.getPosZ(),
            "pos_y": self.data.getPosY(),
            "scan_complete": 0
        }

        id = self.db.insert('systems', data)

    def exists(self):
        systemAddress = self.data.getSystemAddress()
        exists = False

        if systemAddress is not None:
            records = self.db.select("systems", ["id"], {"system_address": systemAddress}, None, 1)
            if records == []:
                exists = False
            else:
                exists = True

        return exists

    def setSystemScanComplete(self, systemAddress):
        self.db.update("systems", {"scan_complete": 1}, {"system_address": systemAddress})

    def setBodyCount(self, systemAddress, bodyCount):
        self.db.update("systems", {"body_count": bodyCount}, {"system_address": systemAddress})
