import json
from package.Import.ImporterBody import ImporterBody


class ImporterStar(ImporterBody):
    def exists(self):
        bodyName = self.data.getName()
        exists = False

        if (self.systemAddress is not None) and (bodyName is not None):
            records = self.db.select("stars", ["id"], {"system_address": self.systemAddress, "name": bodyName}, None, 1)

            if records == []:
                exists = False
            else:
                exists = True

        return exists

    def insert(self):
        # was discoverd
        wasDiscovered = 1
        if not self.data.wasDiscovered():
            wasDiscovered = 0

        # main star - simply where distance = 0 ?
        mainStar = 0
        distance = self.data.getDistance()

        if distance == 0:
            mainStar = 1

        # parents as json string
        parents = json.dumps(self.data.getParents())

        data = {
            "system_address": self.systemAddress,
            "name": self.data.getName(),
            "body_id": self.data.getBodyId(),
            "is_main_star": mainStar,
            "type": self.data.getType(),
            "subclass": self.data.getSubClass(),
            "distance": self.data.getDistance(),
            "mass": self.data.getMass(),
            "radius": self.data.getRadius(),
            "absolute_magnitude": self.data.getAbsoluteMagnitude(),
            "age": self.data.getAge(),
            "temperature": self.data.getTemperature(),
            "luminosity": self.data.getLuminosity(),
            "semi_major_axis": self.data.getSemiMajorAxis(),
            "eccentricity": self.data.getEccentricity(),
            "inclination": self.data.getInclination(),
            "periapsis": self.data.getPeriapsis(),
            "orbital_period": self.data.getOrbitalPeriod(),
            "rotation_period": self.data.getRotationPeriod(),
            "axial_tilt": self.data.getAxialTilt(),
            "was_discovered": wasDiscovered,
            "parents": parents,
            "discovery_date": self.data.getTimestamp()
        }

        starId = self.db.insert('stars', data)
        self.insertRings(starId)

    def insertRings(self, starId):
        if not self.data.hasRings():
            return

        systemAddress = self.systemAddress

        for ring in self.data.getRings():
            name = ring.getName()
            ringClass = ring.getType()
            mass = ring.getMass()
            innerRad = ring.getInnerRadius()
            outerRad = ring.getOuterRadius()

            # we want no asteroid belts for now
            if "Ring" not in name:
                continue

            data = {
                "system_address": systemAddress,
                "name": name,
                "ring_class": ringClass,
                "mass": mass,
                "inner_rad": innerRad,
                "outer_rad": outerRad
            }

            ringId = self.db.insert("rings", data)
            self.createBodyRingXref(starId, ringId)

    def createBodyRingXref(self, starId, ringId):
        data = {
            "ring_id": ringId,
            "star_id": starId
        }

        self.db.insert("body_rings", data)
