from package.Import.ImporterAbstract import ImporterAbstract
from package.Datareader.PlanetReader import PlanetReader


class ImporterScanOrganic(ImporterAbstract):
    def __init__(self):
        super().__init__()
        self.bodyId = None
        self.planetReader = PlanetReader()

    def setCurrentBody(self, currentBody):
        self.bodyId = self.getBodyId(currentBody)

    def insert(self):
        data = {
            "system_address": self.data.getSystemAddress(),
            "body_id": self.bodyId,
            "scan_type": self.data.getScanType(),
            "genus": self.data.getGenus(),
            "genus_localised": self.data.getGenusLocalised(),
            "species": self.data.getSpecies(),
            "species_localised": self.data.getSpeciesLocalised(),
            "date": self.data.getTimestamp(),
            "variant": self.data.getVariant(),
            "variant_localised": self.data.getVariantLocalised(),
        }

        self.db.insert('organic_samples', data)

    def exists(self):
        result = self.db.select("organic_samples", ["id"], {"date": self.data.getTimestamp()})
        if result == []:
            exists = False
        else:
            exists = True

        return exists

    def flush(self):
        super().flush()
        self.bodyId = None

    def getBodyId(self, currentBody):
        if currentBody is None:
            return None

        return self.planetReader.getBodyId(currentBody)
