from .ImporterBody import ImporterBody


class ImporterSAASignal(ImporterBody):
    TYPE_RING = "ring"
    TYPE_PLANET = "planet"

    def __init__(self):
        super().__init__()
        self.selectTable = None
        self.selectColumn = None
        self.selectId = None
        self.type = None

    def flush(self):
        super().flush()
        self.selectTable = None
        self.selectColumn = None
        self.selectId = None
        self.type = None

    def exists(self):
        bodyName = self.data.getBodyName()

        # skip entry if no body name exists
        if bodyName is None:
            return True

        # ring or body?
        if "Ring" in bodyName:
            # select ring id
            result = self.db.select("rings", ["id"], {"name": bodyName}, None, 1)
            if len(result) > 0:
                self.type = self.TYPE_RING
                self.selectTable = "ssa_signals_ring"
                self.selectColumn = "ring_id"
                self.selectId = result[0]["id"]
            else:
                print("ring not in database. skipping ssa entry: " + str(bodyName))
                return True
        else:
            # select body
            result = self.db.select("bodies", ["id"], {"name": bodyName}, None, 1)
            if len(result) > 0:
                self.type = self.TYPE_PLANET
                self.selectTable = "ssa_signals_planet"
                self.selectColumn = "planet_id"
                self.selectId = result[0]["id"]
            else:
                return True

        # entry in ref table?
        data = self.db.select(self.selectTable, ["ssa_id"], {self.selectColumn: self.selectId}, None, 1)
        if data == []:
            exists = False
        else:
            exists = True

        return exists

    def insert(self):
        signals = self.data.getSignals()

        if self.type == self.TYPE_RING:
            self.insertRingSignals(self.selectId, signals)
        elif self.type == self.TYPE_PLANET:
            self.insertPlanetSignals(self.selectId, signals)

    def insertPlanetSignals(self, bodyId, signals):
        for signal in signals:
            ssaId = self.insertSsaSignal(signal)

            if ssaId is not None:
                self.insertPlanetRef(bodyId, ssaId)

    def insertRingSignals(self, ringId, signals):
        for signal in signals:
            ssaId = self.insertSsaSignal(signal)

            if ssaId is not None:
                self.insertRingRef(ringId, ssaId)

    def insertSsaSignal(self, signal):
        type = signal.getType()
        typeLocalised = signal.getTypeLocalised()
        count = signal.getCount()
        ssaId = None

        if type is not None and count != 0:
            data = {
                "type": type,
                "type_localised": typeLocalised,
                "amount": count,
            }

            ssaId = self.db.insert("ssa_signals", data)

        return ssaId

    def insertPlanetRef(self, planetId, ssaId):
        data = {
            "planet_id": planetId,
            "ssa_id": ssaId,
        }

        self.db.insert("ssa_signals_planet", data)

    def insertRingRef(self, ringId, ssaId):
        data = {
            "ring_id": ringId,
            "ssa_id": ssaId,
            "multiple_hotspot": 0
        }

        self.db.insert("ssa_signals_ring", data)
