from .ImporterAbstract import ImporterAbstract

class ImporterMaterial(ImporterAbstract):
    def __init__(self):
        super().__init__()

    def flush(self):
        super().flush()

    def insert(self):
        self.deleteMaterial()

        raw = self.data.getRawMaterials()
        self.insertMaterialType(raw, 'raw')

        raw = self.data.getManufacturedMaterials()
        self.insertMaterialType(raw, 'manufactured')

        raw = self.data.getEncodedMaterials()
        self.insertMaterialType(raw, 'encoded')

    def insertMaterialType(self, materials, type):
        allData = []
        for entry in materials:
            tmp = {
                'name': entry['Name'],
                'category': type,
                'amount': entry['Count']
            }
            allData.append(tmp)

        if len(allData) > 0:
            self.db.insertMany('pilot_materials', allData)

    def deleteMaterial(self):
        self.db.delete('pilot_materials', {})

    def exists(self):
        return False
