from .ImporterBody import ImporterBody
from package.Datareader.PlanetReader import PlanetReader


class ImporterCodex(ImporterBody):
    def __init__(self):
        super().__init__()
        self.bodyId = None
        self.latitude = None
        self.longitude = None
        self.planetReader = PlanetReader()

    def setCurrentBody(self, currentBody):
        self.bodyId = self.getBodyId(currentBody)

    def setLatitude(self, latitude):
        self.latitude = latitude

    def setLongitude(self, longitude):
        self.longitude = longitude

    def flush(self):
        super().flush()
        self.bodyId = None
        self.latitude = None
        self.longitude = None

    def insert(self):
        isNewEntry = 0
        if self.data.isNewEntry():
            isNewEntry = 1

        data = {
            "body_id": self.bodyId,
            "name": self.data.getName(),
            "name_localised": self.data.getNameLocalised(),
            "category": self.data.getCategory(),
            "subcategory": self.data.getSubCategory(),
            "region": self.data.getRegion(),
            "region_localised": self.data.getRegionLocalised(),
            "nearest_destination": self.data.getNearestDestination(),
            "nearest_destination_localised": self.data.getNearestDestinationLocalised(),
            "latitude": self.latitude,
            "longitude": self.longitude,
            "system_address": self.data.getSystemAddress(),
            "is_new_entry": isNewEntry,
            "voucher_amount": self.data.getVoucherAmount(),
            "scan_date": self.data.getTimestamp()
        }

        self.db.insert("codex", data)

    def exists(self):
        # codex entries for stellar bodys are ignored
        if self.data.getCategory() == "$Codex_Category_StellarBodies;":
            return True

        result = self.db.select("codex", ["id"], {"scan_date": self.data.getTimestamp()})
        if result == []:
            exists = False
        else:
            exists = True

        return exists

    def getBodyId(self, currentBody):
        if currentBody is None:
            return None

        return self.planetReader.getBodyId(currentBody)
