from abc import ABC, abstractmethod
from package.Database.DbFactory import DbFactory

class ImporterAbstract(ABC):
    def __init__(self):
        self.db = DbFactory.getDatabase()
        self.data = None

    def insert(self):
        pass

    def exists(self):
        pass

    def process(self, dataObject):
        self.data = dataObject
        if (self.exists() == False):
            self.insert()

    def flush(self):
        self.data = None
