class ImportState:
    _instance = None

    def __init__(self):
        self.currentSystemAddress = None
        self.currentBody = None
        self.latitude = None
        self.longitude = None
        self.bodySignals = {}

        ImportState._instance = self

    @staticmethod
    def getInstance():
        """ Fake singleton for now """
        if ImportState._instance == None:
            ImportState()
        return ImportState._instance

    def reset(self):
        self.currentSystemAddress = None
        self.currentBody = None
        self.latitude = None
        self.longitude = None
        self.bodySignals = {}

    def setCurrentSystemAddress(self, systemAddress):
        self.currentSystemAddress = systemAddress

    def getCurrentSystemAddress(self):
        return self.currentSystemAddress

    def setCurrentBody(self, body):
        self.currentBody = body

    def getCurrentBody(self):
        return self.currentBody

    def setLatitude(self, latitude):
        self.latitude = latitude

    def getLatitute(self):
        return self.latitude

    def setLongitude(self, longitude):
        self.longitude = longitude

    def getLongitude(self):
        return self.longitude

    def addBodySignalEvent(self, key, event):
        self.bodySignals[key] = event

    def getBodySignalEvent(self, key):
        bodySignal = None
        if key in self.bodySignals:
            bodySignal = self.bodySignals[key]

        return bodySignal

    def removeBodySignalEvent(self, key):
        self.bodySignals.pop(key, None)
