from package.Import.ImporterAbstract import ImporterAbstract
from package.Journal.Events.FSDJump import FSDJump


class ImporterFlightLog(ImporterAbstract):
    def insert(self):
        fuelUsed = 0
        fuelLevel = 0
        jumpDistance = 0

        if isinstance(self.data, FSDJump):
            fuelUsed = self.data.getFuelUsed()
            fuelLevel = self.data.getFuelLevel()
            jumpDistance = self.data.getJumpDistance()

        data = {
            "system_address": self.data.getSystemAddress(),
            "jump_distance": jumpDistance,
            "fuel_used": fuelUsed,
            "fuel_level": fuelLevel,
            "date": self.data.getTimestamp()
        }

        id = self.db.insert('flightlog', data)

    def exists(self):
        exists = False
        systemAddress = self.data.getSystemAddress()

        if systemAddress is not None:
            records = self.db.select("flightlog", ["id"], {"system_address": systemAddress, "date": self.data.getTimestamp()}, None, 1)
            if records == []:
                exists = False
            else:
                exists = True

        return exists
