from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *


def getDescLabel(
        text: str = "",
        small: bool = False,
        bold: bool = False
) -> QLabel:
    label = QLabel()
    label.setText(text)
    label.setTextInteractionFlags(Qt.TextSelectableByMouse)

    if small:
        label.setStyleSheet("font-size:8pt")

    if bold:
        boldFont = QFont()
        boldFont.setBold(True)
        label.setFont(boldFont)

    return label

def getContentLabel(
        text: str,
        small: bool = False
) -> QLabel:
    label = QLabel(text)
    label.setTextInteractionFlags(Qt.TextSelectableByMouse)
    label.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Minimum)
    label.setStyleSheet("color: #4d4d4d;")

    boldFont = QFont()
    boldFont.setBold(True)
    label.setFont(boldFont)

    if small:
        label.setStyleSheet("font-size:8pt")

    return label
