import os
from PIL import Image
from package.Config.ConfigManager import ConfigManager


class ScreenshotHandler:
    def processScreenshot(self, entity):
        sourceDir = ConfigManager.getConfigValue("screenshot_source_dir")
        sourceFilename = self.parseFilename(entity.getFilename())
        sourceFull = os.path.join(sourceDir, sourceFilename)

        destinationDir = self.getDestinationDirectoryName(entity)
        destinationFilename = self.getDestinationFileName(entity)
        destinationFull = os.path.join(destinationDir, destinationFilename)

        self.createDestinationDir(destinationDir)
        imgObj = Image.open(sourceFull)
        imgObj.save(destinationFull)

    def parseFilename(self, name):
        return name.replace("\\ED_Pictures\\", "")

    def createDestinationDir(self, destinationDir):
        if not os.path.exists(destinationDir):
            os.mkdir(destinationDir)

    def getDestinationDirectoryName(self, entity):
        destinationBaseDir = ConfigManager.getConfigValue("screenshot_destination_dir")
        dateObj = entity.getTimestamp()
        dateDir = "%s-%s-%s" % (dateObj.year, dateObj.strftime("%m"), dateObj.strftime("%d"))

        destinationDir = os.path.join(destinationBaseDir, dateDir + " " + entity.getSystem())
        return destinationDir

    def getDestinationFileName(self, entity):
        dateObj = entity.getTimestamp()
        dateString = "%s-%s-%s %s%s%s" % (dateObj.year, dateObj.strftime("%m"), dateObj.strftime("%d"), dateObj.strftime("%H"), dateObj.strftime("%M"), dateObj.strftime("%S"))

        screenshotFormat = ConfigManager.getConfigValue("screenshot_format")
        destinationFile = dateString + " " + entity.getBody() + "." + screenshotFormat
        return destinationFile
