import re
from os import listdir


class FileHelper:
    REGEX_LOGFILE_OLD = re.compile(r'^Journal\.[0-9]{12}\.[0-9]{2}\.log$')
    REGEX_LOGFILE_UPDATE11 = re.compile(r'^Journal\.[0-9]{2,4}(-)?[0-9]{2}(-)?[0-9]{2}(T)?[0-9]{2}[0-9]{2}[0-9]{2}\.[0-9]{2}\.log$')

    def getLatestLogFile(self, directory):
        logfiles = self.getSortedLogfiles(directory)
        return logfiles[-1] if len(logfiles) > 0 else None

    def getSortedLogfiles(self, directory):
        # since update 11 there are 2 logfile names. handle the old ones first
        oldLogs = []
        newLogs = []

        # get all logiles
        for file in listdir(directory):
            if self.REGEX_LOGFILE_OLD.search(file):
                oldLogs.append(file)
            elif self.REGEX_LOGFILE_UPDATE11.search(file):
                newLogs.append(file)

        oldLogs = sorted(
            oldLogs,
            key=lambda file: file.split('.')[1:]
        )

        newLogs = sorted(
            newLogs,
            key=lambda file: file.split('.')[1:]
        )

        return oldLogs + newLogs

    def isLogFile(self, file):
        return self.REGEX_LOGFILE_OLD.search(file) or self.REGEX_LOGFILE_UPDATE11.search(file)
