from PyQt5.QtCore import QCoreApplication
import package.Elite.Enum as Enum
from decimal import *
import locale


class Converter:
    @staticmethod
    def celvin2Celsius(kelvin):
        return kelvin - Decimal(Enum.KELVIN_BASE)

    @staticmethod
    def getSunRadii(radius):
        return (1 / Decimal(Enum.SUN_RADIUS)) * radius

    @staticmethod
    def getPeriod(rp):
        if rp is None:
            return "-"

        if rp == 0:
            return '%g' % rp
        elif 0.01 > rp > -0.01:
            # milliseconds
            value = locale.format_string("%.4f", (1000 * rp), True)
            return str(value) + " " + QCoreApplication.translate("Systemview", "ms")
        elif 120 > rp > -120:
            # < 2 minutes as seconds
            value = locale.format_string("%.4f", rp, True)
            return str(value) + " " + QCoreApplication.translate("Systemview", "seconds")
        elif 7200 > rp > -7200:
            # < 2 hours as minutes
            value = (rp / 60)
            value = locale.format_string("%.2f", value, True)
            return str(value) + " " + QCoreApplication.translate("Systemview", "minutes")
        elif -172800 < rp < 172800:
            # < 48 std as hours
            value = (rp / 60) / 60
            value = locale.format_string("%.2f", value, True)
            return str(value) + " " + QCoreApplication.translate("Systemview", "hours")
        elif -63072000 < rp < 63072000:
            # as days
            value = ((rp / 60) / 60) / 24
            value = locale.format_string("%.2f", value, True)
            return str(value) + " " + QCoreApplication.translate("Systemview", "days")
        else:
            # as years
            value = (((rp / 60) / 60) / 24) / 365
            value = locale.format_string("%.2f", value, True)
            return str(value) + " " + QCoreApplication.translate("Systemview", "years")

    @staticmethod
    def getGravity(gravity):
        return (1 / Decimal(Enum.EARTH_GRAVITY)) * gravity
