import locale
from decimal import *
from package.Elite.Enum import LIGHT_SECOND_M

# example: https://www.wolframalpha.com/input/?i=orbital+radius+with+eccentricity+0.993476+and+semimajor+axis+13.50+au

class Apsis:
    @staticmethod
    # semi majoraxis is in meters
    # return value is light seconds
    def calculatePerihelion(semimajorAxis, excentricity):
        perihelionKm = (semimajorAxis / 1000) * (1 - excentricity)
        perihelionLs = perihelionKm / Decimal(LIGHT_SECOND_M / 1000)
        return locale.format_string('%.4f', perihelionLs, True)

    @staticmethod
    # semi majoraxis is in meters
    # return value is light seconds
    def calculateAphelion(semimajorAxis, excentricity):
        aphelionKm = (semimajorAxis / 1000) * (1 + excentricity)
        aphelionLs = aphelionKm / Decimal(LIGHT_SECOND_M / 1000)
        return locale.format_string('%.4f', aphelionLs, True)
