from package.Database.DbFactory import DbFactory


class SystemReader:
    def getSystemData(self, systemAddress):
        db = DbFactory.getDatabase()
        result = db.select("systems", ["name", "pos_x", "pos_y", "pos_z", "body_count", "scan_complete", "system_address"], {'system_address': systemAddress}, None, 1)
        return result[0]

    def searchSystemByName(self, name):
        db = DbFactory.getDatabase()
        query = "select system_address as system_address, name as system_name, pos_x, pos_y, pos_z from systems where name like ? limit 10"
        return db.selectPlain(query, [name + "%"])

    def getStellarPhenomena(self, systemAddress: int) -> list:
        """
        get the stellar phenomena for a system - only those not connected to a body
        :param systemAddress: int
        :return: list[str]
        """
        db = DbFactory.getDatabase()
        query = """select c.name_localised from systems s
                    inner join codex c on c.system_address = s.system_address
                    where c.body_id is NULL and
                        s.system_address = ?
                    group by c.name_localised
        """
        return db.selectPlain(query, [systemAddress])
