from package.Database.DbFactory import DbFactory


class StarReader:
    def getMainStarData(self, systemAddress):
        db = DbFactory.getDatabase()
        result = db.select("stars", ["*"], {'system_address': systemAddress, 'is_main_star': 1}, None, 1)

        if len(result) > 0:
            return result[0]
        else:
            return None

    def getStarsForSystem(self, systemAddress):
        db = DbFactory.getDatabase()
        result = db.select("stars", ["*"], {'system_address': systemAddress}, ["body_id", "ASC"], None)
        if len(result) > 0:
            return result
        else:
            return []

    def getStarDataForName(self, name):
        db = DbFactory.getDatabase()
        result = db.select("stars", ["*"], {'name': name})
        if len(result) > 0:
            return result[0]
        else:
            return []

    def getRingsForStar(self, starId):
        db = DbFactory.getDatabase()

        query = """select r.id, r.system_address, r.name, r.ring_class, r.mass, r.inner_rad, r.outer_rad
                    from body_rings b
                    left join rings r on b.ring_id = r.id
                    where b.star_id = ?
                """
        return db.selectPlain(query, [starId])

    def getSsaSignalsForRing(self, starId: int) -> list:
        db = DbFactory.getDatabase()

        query = """select s.id, s.type, s.type_localised, s.amount, sr.ring_id
                    from ssa_signals s 
                    left join ssa_signals_ring sr on sr.ssa_id = s.id
                    left join body_rings br on br.ring_id = sr.ring_id
                    where br.star_id = ?
                    order by s.amount desc
                """
        return db.selectPlain(query, [starId])

    def searchStarByName(self, name: str) -> list:
        db = DbFactory.getDatabase()
        query = "select st.body_id as body_id, st.name as planet_name, s.system_address as system_address, s.name as system_name " \
                "from stars st " \
                "left join systems s on st.system_address = s.system_address " \
                "where st.name like ? limit 10"
        return db.selectPlain(query, [name + "%"])
