from package.Database.DbFactory import DbFactory
from package.Datareader.FlightlogReader import FlightlogReader


class SpecialSearch:
    def __init__(self):
        super(SpecialSearch, self).__init__()
        self.flightlogReader = FlightlogReader()

    def searchHotSpot(self, ownDiscoveriesOnly: bool = False, hotspotType: str = "Tritium", limit: int = 30):
        db = DbFactory.getDatabase()

        whereAdd = ""
        if ownDiscoveriesOnly:
            whereAdd = " and b.was_discovered = 0 "

        query = "select s.name as specialsearch_system, b.name as specialsearch_detail, " + self.getDistanceSql() + " as specialsearch_distance, " \
              "s.system_address as meta_system_address, b.body_id as meta_body_id " \
              "from systems s " \
              "left join bodies b on b.system_address = s.system_address " \
              "left join body_rings br on br.body_id = b.id " \
              "left join ssa_signals_ring ssar on ssar.ring_id = br.ring_id " \
              "left join ssa_signals ssa on ssa.id = ssar.ssa_id " \
              "where ssa.type = ? " \
              + whereAdd + \
              "order by specialsearch_distance asc " \
              "limit " + str(limit)

        return db.selectPlain(query, [hotspotType])

    def searchStellarPhenomena(self, ownDiscoveriesOnly: bool = False, limit: int = 30):
        db = DbFactory.getDatabase()

        whereAdd = ""
        if ownDiscoveriesOnly:
            whereAdd = " and st.was_discovered = 0 "

        query = "select s.name as specialsearch_system, c.name_localised as specialsearch_detail, " + self.getDistanceSql() + " as specialsearch_distance, " \
                "s.system_address as meta_system_address " \
                "from systems s " \
                "left join codex c on c.system_address = s.system_address " \
                "left join stars st on st.system_address = s.system_address " \
                "where c.body_id is null and " \
                "c.id is not null and " \
                "st.is_main_star = 1 " \
                + whereAdd + \
                "order by specialsearch_distance asc " \
                "limit " + str(limit)

        result = db.selectPlain(query)

        uniqueResult = []
        processedEntries = {}
        for entry in result:
            if entry['meta_system_address'] not in processedEntries:
                uniqueResult.append(entry)
                processedEntries[entry['meta_system_address']] = True

        return uniqueResult

    def getCurrentPosition(self):
        return self.flightlogReader.getCurrentPosition()

    def getDistanceSql(self) -> str:
        pos = self.getCurrentPosition()
        distance = " SQRT(POW((s.pos_x - " + str(pos[0]) + "), 2) + " \
                   "POW((s.pos_y - " + str(pos[2]) + "),2) + " \
                   "POW((s.pos_z - " + str(pos[1]) + "),2)) "

        return distance
