from package.Database.DbFactory import DbFactory

class FlightlogReader():
    def getJumpCount(self):
        db = DbFactory.getDatabase()
        result = db.select('flightlog', ['count(id) as jumps'], {})

        return result[0]['jumps']

    def getFullDistance(self):
        db = DbFactory.getDatabase()
        result = db.select('flightlog', ['sum(jump_distance) as distance'], {})

        distance = result[0]['distance']
        if distance is None:
            distance = 0

        return distance

    def getFuelUsed(self):
        db = DbFactory.getDatabase()
        result = db.select('flightlog', ['sum(fuel_used) as fuel_used'], {})

        fuelUsed = result[0]['fuel_used']
        if fuelUsed is None:
            fuelUsed = 0

        return fuelUsed

    def getFlightLogCount(self):
        db = DbFactory.getDatabase()
        result = db.select('flightlog', ['count(*) as jumps'], {})

        jumps = result[0]['jumps']
        if jumps is None:
            jumps = 0

        return jumps

    def loadEntries(self, offset, limit):
        db = DbFactory.getDatabase()

        query = """select f.system_address as id, st.`type` as flightlog_type, s.name as flightlog_system, f.jump_distance as flightlog_distance, f.date as flightlog_date
                        from flightlog f
                        left join systems s using (system_address)
                        left join stars st on st.system_address = s.system_address and st.distance = 0  
                    order by f.date desc limit """ + str(offset) + "," + str(limit)

        results = db.selectPlain(query)
        return results

    def getCurrentPosition(self):
        db = DbFactory.getDatabase()

        query = """select s.pos_x, s.pos_y, s.pos_z
                        from flightlog f
                        left join systems s using (system_address)  
                    order by f.id desc limit 1"""

        results = db.selectPlain(query)
        if len(results) > 0:
            return [results[0]["pos_x"], results[0]["pos_z"], results[0]["pos_y"]]

    def getLastSystemAddress(self):
        systemAddress = 0
        db = DbFactory.getDatabase()

        result = db.select("flightlog", ["system_address"], {}, ["id", "DESC"], 1)
        if len(result) > 0:
            systemAddress = result[0]["system_address"]

        return systemAddress
