from package.Database.DbMysql import DbMysql
from package.Database.DbSqlite import DbSqlite
from package.Config.ConfigReader import ConfigReader

class DbFactory:
    DB_MYSQL = "mysql"
    DB_SQLITE = "sqlite"

    _currentConnection = None
    _connection = None

    @staticmethod
    def getDatabase():
        if DbFactory._connection is None:
            DbFactory._connection = DbFactory.createConnection()

        return DbFactory._connection

    @staticmethod
    def createConnection():
        configData = ConfigReader.getConfigData()

        if configData["Database"]["DatabaseType"] == DbFactory.DB_MYSQL:
            dbObject = DbMysql(
                configData["Mysql"]["Hostname"],
                configData["Mysql"]["Username"],
                configData["Mysql"]["Password"],
                configData["Mysql"]["DbName"],
                configData["Mysql"]["Port"]
            )
            DbFactory._currentConnection = DbFactory.DB_MYSQL
        elif configData["Database"]["DatabaseType"] == DbFactory.DB_SQLITE:
            dbObject = DbSqlite(configData["Sqlite"])
            DbFactory._currentConnection = DbFactory.DB_SQLITE
        else:
            raise EnvironmentError("Database type not found")

        return dbObject

    @staticmethod
    def resetConnection():
        DbFactory._connection.closeConnection()
        DbFactory._connection = None

    @staticmethod
    def isMySqlConnection():
        return DbFactory._currentConnection == DbFactory.DB_MYSQL

    @staticmethod
    def isSqliteConnection():
        return DbFactory._currentConnection == DbFactory.DB_SQLITE
