import configparser


class ConfigReader:
    configData = None
    configFile = 'config/config.ini'

    @classmethod
    def loadConfig(cls):
        cls.configData = configparser.ConfigParser(allow_no_value=True)
        cls.configData.optionxform = str
        cls.configData.read(cls.configFile)

    @classmethod
    def getConfigData(cls):
        return cls.configData

    @classmethod
    def setValue(cls, section, entry, value):
        cls.configData[section][entry] = value
        with open(cls.configFile, 'w') as configfile:
            cls.configData.write(configfile)

        cls.loadConfig()

    @classmethod
    def addSection(cls, name):
        cls.configData.add_section(name)
