import os
from package.Database.DbFactory import DbFactory


class ConfigManager:
    configChecker = None
    config = None

    @classmethod
    def getChecker(cls, forceReload=False):
        if cls.configChecker is None or forceReload:
            db = DbFactory.getDatabase()
            cls.configChecker = db.select("configChecker", ["*"], {})

        return cls.configChecker

    @classmethod
    def getActiveChecker(cls):
        activeChecker = []
        for check in cls.getChecker():
            if check['active'] == 1:
                activeChecker.append(check)

        return activeChecker

    @classmethod
    def insertChecker(cls, name, active):
        db = DbFactory.getDatabase()
        data = {
            "name": name,
            "active": active
        }
        db.insert("configChecker", data)
        cls.configChecker = None

    @classmethod
    def deleteChecker(cls, id):
        db = DbFactory.getDatabase()
        db.delete("configChecker", {"id": id})
        cls.configChecker = None

    @classmethod
    def initChecker(cls):
        db = DbFactory.getDatabase()

        checkerDir = "package/Observer/Checker/"
        checkerInDir = []
        checkerToDelete = []

        # get all classes in checker dir
        for moduleName in os.listdir(checkerDir):
            if moduleName.endswith(".py"):
                checkerInDir.append(moduleName[0:-3])

        # insert new checker
        for fileChecker in checkerInDir:
            if cls.checkerExists(fileChecker) is False:
                db.insert("configChecker", {"name": fileChecker, "active": 1})

        # delete checker which are in db but not in directory
        for checker in cls.getChecker():
            if checker['name'] not in checkerInDir:
                db.delete("configChecker", {"id": checker["id"]})

        cls.configChecker = None

    @classmethod
    def checkerExists(cls, name):
        exists = False
        for checker in cls.getChecker():
            if checker['name'] == name:
                exists = True

        return exists

    @classmethod
    def loadConfig(cls):
        db = DbFactory.getDatabase()
        cls.config = db.select("config", ["*"], {})

    @classmethod
    def getConfigValue(cls, name):
        if cls.config is None:
            cls.loadConfig()

        for config in cls.config:
            if config['config_name'] == name:
                return config['config_value']

        return None

    @classmethod
    def getConfigValues(cls):
        if cls.config is None:
            cls.loadConfig()

        return cls.config

    @classmethod
    def setConfigValue(cls, key, value):
        db = DbFactory.getDatabase()

        data = {'config_value': value}
        where = {'config_name': key}

        db.update("config", data, where)
        cls.loadConfig()
