from package.Calculator.StarValues import StarValues


#
# Values and formulas used from here:
# https://forums.frontier.co.uk/threads/exploration-value-formulae.232000/
#
# post by commander MattG
#
class StarCalculator:
    @staticmethod
    def calculateValue(starType, mass):
        basicValue = StarCalculator.getBasicValue(starType)
        return round(basicValue + (mass * basicValue / StarValues.MASS_DIVIDER))

    @staticmethod
    def getBasicValue(starType):
        groupName = StarCalculator.getGroupName(starType)
        if groupName is None:
            groupName = starType

        if groupName in StarValues.SPECIFIC_VALUES:
            return StarValues.SPECIFIC_VALUES[groupName]
        else:
            return StarValues.BASIC_VALUE

    @staticmethod
    def getGroupName(starType):
        groupName = None

        for tmpGroupName in StarValues.STAR_GROUPS:
            if starType in StarValues.STAR_GROUPS[tmpGroupName]:
                groupName = tmpGroupName
                break

        return groupName
