#
# Values and formulas used from here:
# https://forums.frontier.co.uk/threads/exploration-value-formulae.232000/
#
# post by commander MattG
#
class PlanetValues:
    Q = 0.56591828
    MIN_VALUE = 500
    BASIC_VALUE = 300
    BASIC_BONUS = 0
    BASIC_BONUS_TERRAFORMABLE = 93328

    MAP_MULTIPLIER = 1
    MAP_MULTIPLIER_MAPPED = 3.3333333333
    MAP_MULTIPLIER_FIRST_MAPPED = 3.699622554
    MAP_MULTIPLIER_FIRST_MAPPED_DISCOVERED = 8.0956
    EFFICIENCY_MULTIPLIER = 1.25

    FIRST_DISCOVERED_MULTIPLIER = 2.6
    MASS_POW = 0.2

    ODYSSEY_MAPPING_BONUS = 0.3
    ODYSSEY_MAPPING_BONUS_DEFAULT = 555

    SPECIFIC_VALUES = {
        "Metal rich body": 21790,
        "High metal content body": 9654,
        "Ammonia world": 96932,
        "Water world": 64831,
        "Earthlike body": 64831,
        "Sudarsky class I gas giant": 1656,
        "Sudarsky class II gas giant": 9654,
    }

    # specific bonus for terraformable worlds
    SPECIFIC_BONUS = {
        "High metal content body": 100677,
        "Water world": 116295,
        "Earthlike body": 116295,
    }