from decimal import *
from package.Calculator.PlanetValues import PlanetValues


#
# Values and formulas used from here:
# https://forums.frontier.co.uk/threads/exploration-value-formulae.232000/
#
# post by commander MattG
#
class PlanetCalculator:
    @staticmethod
    def calculateValue(type, mass, terraformable, mapped=True, wasDiscovered=False, wasMapped=True, efficiencyBonus=True):
        planetValue = PlanetCalculator.getPlanetValue(type, terraformable)
        mapMultiplier = PlanetCalculator.getMapMultiplier(mapped, wasDiscovered, wasMapped)

        value = max((planetValue + (Decimal(planetValue) * pow(mass, Decimal(PlanetValues.MASS_POW)) * Decimal(PlanetValues.Q))) * Decimal(mapMultiplier), Decimal(PlanetValues.MIN_VALUE))

        if mapped:
            #odyssey bonus
            odysseyBonus = PlanetValues.ODYSSEY_MAPPING_BONUS_DEFAULT
            if value * Decimal(PlanetValues.ODYSSEY_MAPPING_BONUS) > odysseyBonus:
                odysseyBonus = value * Decimal(PlanetValues.ODYSSEY_MAPPING_BONUS)

            value = value + odysseyBonus

            if efficiencyBonus:
                value = value * Decimal(PlanetValues.EFFICIENCY_MULTIPLIER)

        if not wasDiscovered:
            value *= Decimal(PlanetValues.FIRST_DISCOVERED_MULTIPLIER)

        return round(value)

    @staticmethod
    def getPlanetValue(type, terraformable):
        value = PlanetCalculator.getValue(type)
        bonus = PlanetCalculator.getSpecificBonus(type, terraformable)

        return value + bonus

    @staticmethod
    def getValue(type):
        value = PlanetValues.BASIC_VALUE

        if type in PlanetValues.SPECIFIC_VALUES:
            value = PlanetValues.SPECIFIC_VALUES[type]

        return value

    @staticmethod
    def getSpecificBonus(type, terraformable):
        bonus = PlanetValues.BASIC_BONUS

        if terraformable:
            if type in PlanetValues.SPECIFIC_BONUS:
                bonus = PlanetValues.SPECIFIC_BONUS[type]
            else:
                bonus = PlanetValues.BASIC_BONUS_TERRAFORMABLE


        if type == "Earthlike body":
            bonus = PlanetValues.SPECIFIC_BONUS[type]

        return bonus

    @staticmethod
    def getMapMultiplier(mapped, wasDiscovered, wasMapped):
        multiplier = PlanetValues.MAP_MULTIPLIER

        if mapped:
            multiplier = PlanetValues.MAP_MULTIPLIER_MAPPED

            if not wasDiscovered and not wasMapped:
                multiplier = PlanetValues.MAP_MULTIPLIER_FIRST_MAPPED
            elif wasDiscovered and not wasMapped:
                multiplier = PlanetValues.MAP_MULTIPLIER_FIRST_MAPPED_DISCOVERED

        return multiplier
